/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util;

import java.awt.Color;

public final class Colors {
    private Colors() {
    }

    public static Color darker(Color c, double value) {
        if (c == null) {
            return null;
        }
        if (value < 0.0) {
            return Colors.brighter(c, -value);
        }
        if (value > 1.0) {
            value = 1.0;
        }
        value = 1.0 - value;
        return new Color((int)((double)c.getRed() * value), (int)((double)c.getGreen() * value), (int)((double)c.getBlue() * value));
    }

    public static Color brighter(Color c, double value) {
        if (c == null) {
            return null;
        }
        if (value < 0.0) {
            return Colors.darker(c, -value);
        }
        if (value > 1.0) {
            value = 1.0;
        }
        int dr = 255 - c.getRed();
        int dg = 255 - c.getGreen();
        int db = 255 - c.getBlue();
        Color back = new Color(c.getRed() + (int)((double)dr * value), c.getGreen() + (int)((double)dg * value), c.getBlue() + (int)((double)db * value));
        return back;
    }

    public static Color deltaBrightness(Color c, double delta) {
        if (c == null) {
            return null;
        }
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getBlue(), c.getGreen(), null);
        hsb[2] = (float)((double)hsb[2] + delta);
        hsb[2] = Math.max(0.0f, Math.min(1.0f, hsb[2]));
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public static Color between(Color a, Color b, double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        int red = (int)((double)a.getRed() + value * (double)(b.getRed() - a.getRed()));
        int green = (int)((double)a.getGreen() + value * (double)(b.getGreen() - a.getGreen()));
        int blue = (int)((double)a.getBlue() + value * (double)(b.getBlue() - a.getBlue()));
        return new Color(red, green, blue);
    }

    public static Color between(Color a, double weightA, Color b, double weightB, Color c, double weightC) {
        double sum = weightA + weightB + weightC;
        double red = (double)a.getRed() * (weightA /= sum) + (double)b.getRed() * (weightB /= sum) + (double)c.getRed() * (weightC /= sum);
        double green = (double)a.getGreen() * weightA + (double)b.getGreen() * weightB + (double)c.getGreen() * weightC;
        double blue = (double)a.getBlue() * weightA + (double)b.getBlue() * weightB + (double)c.getBlue() * weightC;
        return new Color(Math.max(0, Math.min((int)red, 255)), Math.max(0, Math.min((int)green, 255)), Math.max(0, Math.min((int)blue, 255)));
    }

    public static Color middle(Color a, Color b) {
        return Colors.between(a, b, 0.5);
    }

    public static Color fuller(Color color, double factor) {
        int b;
        int g;
        int max;
        if (color == null) {
            return null;
        }
        int r = color.getRed();
        r = r < (max = Math.max(r, Math.max(g = color.getGreen(), b = color.getBlue()))) ? (int)((double)r * (1.0 - factor)) : (int)((double)r + (double)r * factor);
        g = g < max ? (int)((double)g * (1.0 - factor)) : (int)((double)g + (double)g * factor);
        b = b < max ? (int)((double)b * (1.0 - factor)) : (int)((double)b + (double)b * factor);
        return new Color(Math.max(0, Math.min(255, r)), Math.max(0, Math.min(255, g)), Math.max(0, Math.min(255, b)));
    }

    public static Color undiffMirror(Color color, double factor) {
        if (color == null) {
            return null;
        }
        int sum = color.getRed() + color.getGreen() + color.getBlue();
        if ((double)sum > 382.5) {
            return Colors.brighter(color, factor);
        }
        return Colors.darker(color, factor);
    }

    public static Color diffMirror(Color color, double factor) {
        if (color == null) {
            return null;
        }
        int sum = color.getRed() + color.getGreen() + color.getBlue();
        if ((double)sum < 382.5) {
            return Colors.brighter(color, factor);
        }
        return Colors.darker(color, factor);
    }

    public static Color darker(Color color) {
        if (color == null) {
            return null;
        }
        return color.darker();
    }

    public static Color brighter(Color color) {
        if (color == null) {
            return null;
        }
        return color.brighter();
    }
}

