/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.xml;

import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XContainer;
import bibliothek.util.xml.XException;
import bibliothek.util.xml.XIO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class XElement
extends XContainer
implements Iterable<XElement> {
    private List<XAttribute> attributes = new ArrayList<XAttribute>();
    private List<XElement> children = new ArrayList<XElement>();
    private String name;

    public XElement(String name) {
        this.setName(name);
    }

    @Override
    public XElement copy() {
        XElement copy = new XElement(this.name);
        copy.copy(this);
        return copy;
    }

    public void copy(XElement original) {
        super.copy(original);
        this.attributes.clear();
        for (XAttribute attr : original.attributes) {
            this.attributes.add(attr.copy());
        }
        this.children.clear();
        for (XElement child : original.children) {
            this.children.add(child.copy());
        }
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Iterator<XElement> iterator() {
        return this.children.iterator();
    }

    public XAttribute[] attributes() {
        return this.attributes.toArray(new XAttribute[this.attributes.size()]);
    }

    public XElement[] children() {
        return this.children.toArray(new XElement[this.children.size()]);
    }

    public XElement addAttribute(XAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute must not be null");
        }
        if (this.getAttribute(attribute.getName()) != null) {
            throw new IllegalArgumentException("attribute '" + attribute.getName() + "' has already been added to this element");
        }
        this.attributes.add(attribute);
        return this;
    }

    public XAttribute removeAttribute(String name) {
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            if (!this.attributes.get(i).getName().equals(name)) continue;
            return this.attributes.remove(i);
        }
        return null;
    }

    public boolean removeAttribute(XAttribute attribute) {
        return this.attributes.remove(attribute);
    }

    public XElement addByte(String name, byte value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setByte(value);
        this.addAttribute(attribute);
        return this;
    }

    public XElement addShort(String name, short value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setShort(value);
        this.addAttribute(attribute);
        return this;
    }

    public XElement addInt(String name, int value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setInt(value);
        this.addAttribute(attribute);
        return this;
    }

    public XElement addLong(String name, long value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setLong(value);
        this.addAttribute(attribute);
        return this;
    }

    public XElement addFloat(String name, float value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setFloat(value);
        this.addAttribute(attribute);
        return this;
    }

    public XElement addDouble(String name, double value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setDouble(value);
        this.addAttribute(attribute);
        return this;
    }

    public XElement addChar(String name, char value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setChar(value);
        this.addAttribute(attribute);
        return this;
    }

    public XElement addString(String name, String value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setString(value);
        this.addAttribute(attribute);
        return this;
    }

    public XElement addBoolean(String name, boolean value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setBoolean(value);
        this.addAttribute(attribute);
        return this;
    }

    public XElement addByteArray(String name, byte[] value) {
        XAttribute attribute = new XAttribute(name);
        attribute.setByteArray(value);
        this.addAttribute(attribute);
        return this;
    }

    public boolean attributeExists(String name) {
        return this.getAttribute(name) != null;
    }

    public XAttribute getAttribute(String name) {
        for (XAttribute check : this.attributes) {
            if (!check.getName().equals(name)) continue;
            return check;
        }
        return null;
    }

    public byte getByte(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getByte();
    }

    public short getShort(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getShort();
    }

    public int getInt(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getInt();
    }

    public long getLong(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getLong();
    }

    public float getFloat(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getFloat();
    }

    public double getDouble(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getDouble();
    }

    public char getChar(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getChar();
    }

    public String getString(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getString();
    }

    public boolean getBoolean(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getBoolean();
    }

    public byte[] getByteArray(String name) {
        XAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new XException("no attribute known with name: " + name);
        }
        return attribute.getByteArray();
    }

    public boolean removeElement(XElement element) {
        return this.children.remove(element);
    }

    public void addElement(XElement element) {
        if (element == null) {
            throw new NullPointerException("element must not be null");
        }
        this.children.add(element);
    }

    public XElement addElement(String name) {
        XElement element = new XElement(name);
        this.addElement(element);
        return element;
    }

    public XElement getElement(String name) {
        for (XElement element : this.children) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public int getElementCount() {
        return this.children.size();
    }

    public XElement getElement(int index) {
        return this.children.get(index);
    }

    public XElement[] getElements(String name) {
        LinkedList<XElement> elements = new LinkedList<XElement>();
        for (XElement element : this.children) {
            if (!element.getName().equals(name)) continue;
            elements.add(element);
        }
        return elements.toArray(new XElement[elements.size()]);
    }

    public XElement[] getElements(String ... names) {
        LinkedList<XElement> elements = new LinkedList<XElement>();
        block0: for (XElement element : this.children) {
            for (String name : names) {
                if (!element.getName().equals(name)) continue;
                elements.add(element);
                continue block0;
            }
        }
        return elements.toArray(new XElement[elements.size()]);
    }

    @Override
    public void setString(String s) {
        if (((String)s).length() == 0) {
            s = "[]";
        } else if (Character.isWhitespace(((String)s).charAt(0)) || Character.isWhitespace(((String)s).charAt(((String)s).length() - 1))) {
            s = "[" + (String)s + "]";
        } else if (((String)s).charAt(0) == '[' && ((String)s).charAt(((String)s).length() - 1) == ']') {
            s = "[" + (String)s + "]";
        }
        super.setString((String)s);
    }

    @Override
    public String getString() {
        String s = super.getString();
        if (s.startsWith("[") && s.endsWith("]")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            XIO.write(this, builder);
        }
        catch (IOException e) {
            throw new XException(e);
        }
        return builder.toString();
    }
}

