/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.FieldVisitor;
import net.sf.retrotranslator.runtime.asm.Label;
import net.sf.retrotranslator.runtime.asm.MethodAdapter;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.asm.Type;
import net.sf.retrotranslator.runtime.asm.commons.LocalVariablesSorter;
import net.sf.retrotranslator.runtime.impl.EmptyVisitor;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.TargetEnvironment;
import net.sf.retrotranslator.transformer.TransformerTools;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryModelVisitor
extends ClassAdapter {
    private static final int ACCESS_MASK = 7;
    private static final Type OBJECT_TYPE;
    private final Map<String, Map<String, FieldInfo>> locks = new HashMap<String, Map<String, FieldInfo>>();
    private final TargetEnvironment environment;
    private final boolean syncvolatile;
    private final boolean syncfinal;
    private String internalName;
    private boolean initialized;
    static /* synthetic */ Class class$java$lang$Object;

    public MemoryModelVisitor(ClassVisitor visitor, TargetEnvironment environment, boolean syncvolatile, boolean syncfinal) {
        super(visitor);
        this.environment = environment;
        this.syncvolatile = syncvolatile;
        this.syncfinal = syncfinal;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.internalName = name;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<clinit>")) {
            this.initialized = true;
            List<FieldInfo> locks = this.getNewLocks(this.internalName);
            if (!locks.isEmpty()) {
                visitor = new LockIntroductionVisitor(visitor, locks);
            }
        }
        return new SynchronizationVisitor(access, desc, visitor);
    }

    @Override
    public void visitEnd() {
        List<FieldInfo> locks;
        if (!this.initialized && !(locks = this.getNewLocks(this.internalName)).isEmpty()) {
            LockIntroductionVisitor visitor = new LockIntroductionVisitor(super.visitMethod(8, "<clinit>", TransformerTools.descriptor(Void.TYPE, new Class[0]), null, null), locks);
            visitor.visitCode();
            visitor.visitInsn(177);
            visitor.visitMaxs(0, 0);
            visitor.visitEnd();
        }
        super.visitEnd();
    }

    private List<FieldInfo> getNewLocks(String owner) {
        ArrayList<FieldInfo> result = new ArrayList<FieldInfo>();
        for (FieldInfo info : this.getLocks(owner).values()) {
            if (info.desc != null) continue;
            result.add(info);
        }
        return result;
    }

    private Map<String, FieldInfo> getLocks(String owner) {
        Map<String, FieldInfo> result = this.locks.get(owner);
        if (result == null) {
            LockDetectionVisitor lockDetectionVisitor = new LockDetectionVisitor();
            ClassReader reader = this.environment.findClassReader(owner);
            if (reader != null) {
                reader.accept(lockDetectionVisitor, true);
            }
            result = lockDetectionVisitor.getLocks();
            this.locks.put(owner, result);
        }
        return result;
    }

    private static boolean isSet(int access, int flag) {
        return (access & flag) != 0;
    }

    static {
        Class<?> clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        OBJECT_TYPE = Type.getType(clazz);
    }

    private class SynchronizationVisitor
    extends LocalVariablesSorter {
        public SynchronizationVisitor(int access, String desc, MethodVisitor mv) {
            super(access, desc, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            FieldInfo lock = (FieldInfo)MemoryModelVisitor.this.getLocks(owner).get(name);
            if (lock == null) {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
                return;
            }
            int lockVar = this.newLocal(1);
            int exceptionVar = this.newLocal(1);
            Label syncStart = new Label();
            Label syncEnd = new Label();
            Label catchStart = new Label();
            Label catchEnd = new Label();
            Label blockEnd = new Label();
            this.mv.visitTryCatchBlock(syncStart, syncEnd, catchStart, null);
            this.mv.visitTryCatchBlock(catchStart, catchEnd, catchStart, null);
            this.mv.visitFieldInsn(178, owner, lock.name, OBJECT_TYPE.getDescriptor());
            this.mv.visitInsn(89);
            this.mv.visitVarInsn(58, lockVar);
            this.mv.visitInsn(194);
            this.mv.visitLabel(syncStart);
            this.mv.visitFieldInsn(opcode, owner, name, desc);
            this.mv.visitVarInsn(25, lockVar);
            this.mv.visitInsn(195);
            this.mv.visitLabel(syncEnd);
            this.mv.visitJumpInsn(167, blockEnd);
            this.mv.visitLabel(catchStart);
            this.mv.visitVarInsn(58, exceptionVar);
            this.mv.visitVarInsn(25, lockVar);
            this.mv.visitInsn(195);
            this.mv.visitLabel(catchEnd);
            this.mv.visitVarInsn(25, exceptionVar);
            this.mv.visitInsn(191);
            this.mv.visitLabel(blockEnd);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LockIntroductionVisitor
    extends MethodAdapter {
        private final List<FieldInfo> locks;

        public LockIntroductionVisitor(MethodVisitor visitor, List<FieldInfo> locks) {
            super(visitor);
            this.locks = locks;
        }

        @Override
        public void visitCode() {
            super.visitCode();
            for (FieldInfo lock : this.locks) {
                this.mv.visitTypeInsn(187, OBJECT_TYPE.getInternalName());
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(183, OBJECT_TYPE.getInternalName(), "<init>", TransformerTools.descriptor(Void.TYPE, new Class[0]));
                this.mv.visitFieldInsn(179, MemoryModelVisitor.this.internalName, lock.name, OBJECT_TYPE.getDescriptor());
            }
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            for (FieldInfo lock : this.locks) {
                MemoryModelVisitor.this.cv.visitField(lock.access, lock.name, OBJECT_TYPE.getDescriptor(), null, null).visitEnd();
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LockDetectionVisitor
    extends EmptyVisitor {
        private final Map<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        private boolean isJava5Class;

        private LockDetectionVisitor() {
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.isJava5Class = ClassVersion.VERSION_15.getVersion() == version || ClassVersion.VERSION_15.isBefore(version);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.fields.put(name, new FieldInfo(access, name, desc));
            return super.visitField(access, name, desc, signature, value);
        }

        public Map<String, FieldInfo> getLocks() {
            TreeMap<String, FieldInfo> result = new TreeMap<String, FieldInfo>();
            for (FieldInfo info : this.fields.values()) {
                FieldInfo fieldInfo;
                if ((!MemoryModelVisitor.this.syncvolatile || !MemoryModelVisitor.isSet(info.access, 64)) && (!MemoryModelVisitor.this.syncfinal || !MemoryModelVisitor.isSet(info.access, 16) || MemoryModelVisitor.isSet(info.access, 8)) || (fieldInfo = this.getLock(info)) == null) continue;
                result.put(info.name, fieldInfo);
            }
            return result;
        }

        private FieldInfo getLock(FieldInfo fieldInfo) {
            FieldInfo lockInfo;
            String lockName = new StringBuffer().append(fieldInfo.name).append("$lock").toString();
            while ((lockInfo = this.fields.get(lockName)) != null) {
                if (MemoryModelVisitor.isSet(lockInfo.access, 8) && lockInfo.desc.equals(OBJECT_TYPE.getDescriptor()) && (lockInfo.access & 7) == (fieldInfo.access & 7)) {
                    return lockInfo;
                }
                lockName = new StringBuffer().append(lockName).append("$").toString();
            }
            if (this.isJava5Class) {
                return new FieldInfo(fieldInfo.access & 7 | 8 | 0x10 | 0x1000, lockName, null);
            }
            return null;
        }
    }

    private static class FieldInfo {
        public final int access;
        public final String name;
        public final String desc;

        private FieldInfo(int access, String name, String desc) {
            this.access = access;
            this.name = name;
            this.desc = desc;
        }
    }
}

