/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.Label;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.transformer.AbstractMethodVisitor;

public class SynchronizedBlockVisitor
extends ClassAdapter {
    public SynchronizedBlockVisitor(ClassVisitor visitor) {
        super(visitor);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        return methodVisitor == null ? null : new SynchronizedBlockMethodVisitor(methodVisitor);
    }

    private static class SynchronizedBlockMethodVisitor
    extends AbstractMethodVisitor {
        private final List<TryCatchBlock> blocks = new ArrayList<TryCatchBlock>();
        private Step step;
        private Label startLabel;
        private Label endLabel;
        private Integer exceptionVar;
        private int monitorVar;

        public SynchronizedBlockMethodVisitor(MethodVisitor visitor) {
            super(visitor);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.blocks.add(new TryCatchBlock(start, end, handler, type));
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            Iterator<TryCatchBlock> i$ = this.blocks.iterator();
            while (i$.hasNext()) {
                TryCatchBlock block = i$.next();
                this.mv.visitTryCatchBlock(block.start, block.end, block.handler, block.type);
            }
            super.visitMaxs(maxStack, maxLocals);
        }

        protected void flush() {
            this.step = null;
        }

        public void visitLabel(Label label) {
            this.mv.visitLabel(label);
            if (this.step == Step.MONITOR_EXITED) {
                this.endLabel = label;
                this.step = Step.BLOCK_FINISHED;
            } else {
                this.startLabel = label;
                this.step = Step.BLOCK_STARTED;
            }
        }

        public void visitVarInsn(int opcode, int var) {
            this.mv.visitVarInsn(opcode, var);
            if (this.step == Step.BLOCK_STARTED && opcode == 58) {
                this.exceptionVar = _Integer.valueOf(var);
                this.step = Step.EXCEPTION_STORED;
            } else if (this.step == Step.BLOCK_STARTED && opcode == 25) {
                this.exceptionVar = null;
                this.monitorVar = var;
                this.step = Step.MONITOR_LOADED;
            } else if (this.step == Step.EXCEPTION_STORED && opcode == 25) {
                this.monitorVar = var;
                this.step = Step.MONITOR_LOADED;
            } else {
                this.step = this.step == Step.BLOCK_FINISHED && opcode == 25 && var == this.exceptionVar ? Step.EXCEPTION_LOADED : null;
            }
        }

        public void visitInsn(int opcode) {
            this.mv.visitInsn(opcode);
            if (this.step == Step.MONITOR_LOADED && opcode == 195) {
                this.step = Step.MONITOR_EXITED;
            } else if (this.step == Step.EXCEPTION_LOADED && opcode == 191) {
                this.checkBlock();
                this.step = null;
            } else if (this.step == Step.BLOCK_FINISHED && opcode == 191 && this.exceptionVar == null) {
                this.checkBlock();
                this.step = null;
            } else {
                this.step = null;
            }
        }

        private void checkBlock() {
            int blockIndex = this.findBlockIndex();
            if (blockIndex < 0) {
                return;
            }
            TryCatchBlock block = this.blocks.get(blockIndex);
            block.monitorBlock = true;
            if (block.handler != block.start) {
                return;
            }
            if (blockIndex > 0 && this.blocks.get((int)(blockIndex - 1)).monitorBlock) {
                return;
            }
            Label startLabel = new Label();
            Label endLabel = new Label();
            block.handler = startLabel;
            this.mv.visitLabel(startLabel);
            if (this.exceptionVar != null) {
                this.mv.visitVarInsn(58, this.exceptionVar);
            }
            this.mv.visitVarInsn(25, this.monitorVar);
            this.mv.visitInsn(195);
            this.mv.visitLabel(endLabel);
            if (this.exceptionVar != null) {
                this.mv.visitVarInsn(25, this.exceptionVar);
            }
            this.mv.visitInsn(191);
            this.blocks.add(blockIndex + 1, new TryCatchBlock(startLabel, endLabel, startLabel, null));
        }

        private int findBlockIndex() {
            for (int i = 0; i < this.blocks.size(); ++i) {
                TryCatchBlock block = this.blocks.get(i);
                if (block.start != this.startLabel || block.end != this.endLabel || block.type != null) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Step
    extends Enum_<Step> {
        public static final Step BLOCK_STARTED = new Step("BLOCK_STARTED", 0);
        public static final Step EXCEPTION_STORED = new Step("EXCEPTION_STORED", 1);
        public static final Step MONITOR_LOADED = new Step("MONITOR_LOADED", 2);
        public static final Step MONITOR_EXITED = new Step("MONITOR_EXITED", 3);
        public static final Step BLOCK_FINISHED = new Step("BLOCK_FINISHED", 4);
        public static final Step EXCEPTION_LOADED = new Step("EXCEPTION_LOADED", 5);
        private static final /* synthetic */ Step[] $VALUES;
        static /* synthetic */ Class class$net$sf$retrotranslator$transformer$SynchronizedBlockVisitor$Step;

        public static final Step[] values() {
            return (Step[])$VALUES.clone();
        }

        public static Step valueOf(String name) {
            Class<?> clazz = class$net$sf$retrotranslator$transformer$SynchronizedBlockVisitor$Step;
            if (clazz == null) {
                clazz = class$net$sf$retrotranslator$transformer$SynchronizedBlockVisitor$Step = new Step[0].getClass().getComponentType();
            }
            return (Step)Enum_.valueOf(clazz, name);
        }

        private Step() {
            super(var1_1, n);
        }

        static {
            $VALUES = new Step[]{BLOCK_STARTED, EXCEPTION_STORED, MONITOR_LOADED, MONITOR_EXITED, BLOCK_FINISHED, EXCEPTION_LOADED};
        }
    }

    private static class TryCatchBlock {
        public final Label start;
        public final Label end;
        public Label handler;
        public final String type;
        public boolean monitorBlock;

        public TryCatchBlock(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

