/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.exploration;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.extension.api.ContextMenuAdapter;
import de.uka.ilkd.key.gui.extension.api.ContextMenuKind;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.prooftree.Styler;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofTreeAdapter;
import de.uka.ilkd.key.proof.ProofTreeEvent;
import de.uka.ilkd.key.proof.ProofTreeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.key_project.exploration.ExplorationModeModel;
import org.key_project.exploration.ExplorationNodeData;
import org.key_project.exploration.ExplorationRenderer;
import org.key_project.exploration.actions.AddFormulaToAntecedentAction;
import org.key_project.exploration.actions.AddFormulaToSuccedentAction;
import org.key_project.exploration.actions.DeleteFormulaAction;
import org.key_project.exploration.actions.EditFormulaAction;
import org.key_project.exploration.actions.ShowInteractiveBranchesAction;
import org.key_project.exploration.actions.ToggleExplorationAction;
import org.key_project.exploration.ui.ExplorationStepsList;

@KeYGuiExtension.Info(name="Exploration", description="Author: Sarah Grebing <grebing@ira.uka.de>, Alexander Weigl <weigl@ira.uka.de>", experimental=false, optional=true, priority=10000)
public class ExplorationExtension
implements KeYGuiExtension,
KeYGuiExtension.ContextMenu,
KeYGuiExtension.Startup,
KeYGuiExtension.Toolbar,
KeYGuiExtension.MainMenu,
KeYGuiExtension.LeftPanel,
KeYGuiExtension.StatusLine {
    private final ExplorationModeModel model = new ExplorationModeModel();
    private JToolBar explorationToolbar;
    private ExplorationStepsList leftPanel;
    private final ContextMenuAdapter adapter = new ContextMenuAdapter(){

        public List<Action> getContextActions(KeYMediator mediator, ContextMenuKind kind, PosInSequent pos) {
            if (ExplorationExtension.this.model.isExplorationModeSelected()) {
                return Arrays.asList(new Action[]{new AddFormulaToAntecedentAction(), new AddFormulaToSuccedentAction(), new EditFormulaAction(pos), new DeleteFormulaAction(pos)});
            }
            return super.getContextActions(mediator, kind, pos);
        }
    };
    private final ProofTreeListener proofTreeListener = new ProofTreeAdapter(){

        public void proofPruned(ProofTreeEvent e) {
            e.getNode().deregister((Object)((ExplorationNodeData)e.getNode().lookup(ExplorationNodeData.class)), ExplorationNodeData.class);
        }
    };

    @Nonnull
    public List<Action> getContextActions(@Nonnull KeYMediator mediator, @Nonnull ContextMenuKind kind, @Nonnull Object underlyingObject) {
        return this.adapter.getContextActions(mediator, kind, underlyingObject);
    }

    @Nonnull
    public JToolBar getToolbar(MainWindow mainWindow) {
        if (this.explorationToolbar == null) {
            this.explorationToolbar = new JToolBar();
            this.explorationToolbar.add(new JCheckBox((Action)((Object)new ToggleExplorationAction(this.model, mainWindow))));
            this.explorationToolbar.add(new JCheckBox((Action)((Object)new ShowInteractiveBranchesAction(this.model, mainWindow))));
        }
        return this.explorationToolbar;
    }

    public void init(MainWindow window, final KeYMediator mediator) {
        mediator.register((Object)this.model, ExplorationModeModel.class);
        mediator.addKeYSelectionListener(new KeYSelectionListener(){

            public void selectedNodeChanged(KeYSelectionEvent e) {
            }

            public void selectedProofChanged(KeYSelectionEvent e) {
                Proof newProof;
                Proof oldProof = ExplorationExtension.this.leftPanel.getProof();
                if (oldProof != (newProof = mediator.getSelectedProof())) {
                    ExplorationExtension.this.leftPanel.setProof(newProof);
                    if (oldProof != null) {
                        oldProof.removeProofTreeListener(ExplorationExtension.this.proofTreeListener);
                    }
                    if (newProof != null) {
                        newProof.addProofTreeListener(ExplorationExtension.this.proofTreeListener);
                    }
                }
            }
        });
        window.getProofTreeView().getRenderer().add((Styler)new ExplorationRenderer());
    }

    private void initLeftPanel(@Nonnull MainWindow window) {
        this.leftPanel = new ExplorationStepsList(window);
        this.leftPanel.setEnabled(this.model.isExplorationModeSelected());
        this.model.addPropertyChangeListener("exploreModeSelected", e -> this.leftPanel.setEnabled(this.model.isExplorationModeSelected()));
    }

    @Nonnull
    public Collection<TabPanel> getPanels(@Nonnull MainWindow window, @Nonnull KeYMediator mediator) {
        if (this.leftPanel == null) {
            this.initLeftPanel(window);
        }
        return Collections.singleton(this.leftPanel);
    }

    public List<JComponent> getStatusLineComponents() {
        if (this.leftPanel == null) {
            this.initLeftPanel(MainWindow.getInstance());
        }
        return Collections.singletonList(this.leftPanel.getHasExplorationSteps());
    }

    @Nonnull
    public List<Action> getMainMenuActions(@Nonnull MainWindow mainWindow) {
        return Arrays.asList(new Action[]{new ToggleExplorationAction(this.model, mainWindow), new ShowInteractiveBranchesAction(this.model, mainWindow)});
    }
}

