/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.exploration;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeModel;
import de.uka.ilkd.key.gui.prooftree.ProofTreeViewFilter;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class ExplorationModeModel {
    public static final String PROP_EXPLORE_MODE = "exploreModeSelected";
    public static final String PROP_EXPLORE_TACLET_APP_STATE = "exploreTacletAppState";
    private final Map<Proof, AtomicInteger> taintedProofs = new WeakHashMap<Proof, AtomicInteger>();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    @Nonnull
    private ExplorationState explorationTacletAppState = ExplorationState.WHOLE_APP;
    private boolean explorationModeSelected = false;

    @Nonnull
    public ExplorationState getExplorationTacletAppState() {
        return this.explorationTacletAppState;
    }

    public void setExplorationTacletAppState(ExplorationState explorationTacletAppState) {
        boolean old = this.explorationModeSelected;
        this.explorationTacletAppState = explorationTacletAppState;
        this.changeSupport.firePropertyChange(PROP_EXPLORE_TACLET_APP_STATE, old, this.explorationModeSelected);
    }

    public boolean isExplorationModeSelected() {
        return this.explorationModeSelected;
    }

    public void setExplorationModeSelected(boolean explorationModeSelected) {
        boolean old = this.explorationModeSelected;
        this.explorationModeSelected = explorationModeSelected;
        this.changeSupport.firePropertyChange(PROP_EXPLORE_MODE, old, explorationModeSelected);
    }

    public boolean isShowInteractiveBranches() {
        return !ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getHideInteractiveGoals();
    }

    public AtomicInteger get(Proof p) {
        return this.taintedProofs.computeIfAbsent(p, e -> new AtomicInteger(0));
    }

    public void setShowInteractiveBranches(boolean showInteractiveBranches) {
        GUIProofTreeModel delegateModel = MainWindow.getInstance().getProofTreeView().getDelegateModel();
        delegateModel.setFilter(ProofTreeViewFilter.HIDE_INTERACTIVE_GOALS, !showInteractiveBranches);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public static enum ExplorationState {
        WHOLE_APP,
        SIMPLIFIED_APP;

    }
}

