/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.exploration;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Semisequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.SchemaVariable;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.rule.FindTaclet;
import de.uka.ilkd.key.rule.MatchConditions;
import de.uka.ilkd.key.rule.NoPosTacletApp;
import de.uka.ilkd.key.rule.PosTacletApp;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.TacletApp;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.key_project.exploration.ExplorationNodeData;
import org.key_project.util.collection.ImmutableList;

public class ProofExplorationService {
    @Nonnull
    private final Proof proof;
    @Nonnull
    private final Services services;

    public ProofExplorationService(@Nonnull Proof proof, @Nonnull Services services) {
        this.proof = proof;
        this.services = services;
    }

    @Nonnull
    public static ProofExplorationService get(KeYMediator mediator) {
        return ProofExplorationService.get(mediator.getSelectedProof());
    }

    @Nonnull
    private static ProofExplorationService get(Proof selectedProof) {
        ProofExplorationService service = (ProofExplorationService)selectedProof.lookup(ProofExplorationService.class);
        if (service == null) {
            service = new ProofExplorationService(selectedProof, selectedProof.getServices());
            selectedProof.register((Object)service, ProofExplorationService.class);
        }
        return service;
    }

    private Taclet getTaclet(String name) {
        return this.proof.getEnv().getInitConfigForEnvironment().lookupActiveTaclet(new Name(name));
    }

    private FindTaclet getHideTaclet(boolean inAntec) {
        return (FindTaclet)this.getTaclet(inAntec ? "hide_left" : "hide_right");
    }

    @Nonnull
    public Taclet getCutTaclet() {
        return Objects.requireNonNull(this.proof.getEnv().getInitConfigForEnvironment().lookupActiveTaclet(new Name("cut")));
    }

    @Nonnull
    public Node soundAddition(@Nonnull Goal g, @Nonnull Term t, boolean antecedent) {
        Node toBeSelected;
        Taclet cut = g.proof().getEnv().getInitConfigForEnvironment().lookupActiveTaclet(new Name("cut"));
        Semisequent semisequent = new Semisequent(new SequentFormula(t));
        NoPosTacletApp app = NoPosTacletApp.createNoPosTacletApp((Taclet)cut);
        SchemaVariable sv = (SchemaVariable)app.uninstantiatedVars().iterator().next();
        app = app.addCheckedInstantiation(sv, semisequent.getFirst().formula(), this.services, true);
        ExplorationNodeData explorationNodeData = new ExplorationNodeData();
        if (antecedent) {
            explorationNodeData.setExplorationAction("Added " + t + " ==>");
        } else {
            explorationNodeData.setExplorationAction("Added ==> " + t);
        }
        g.node().register((Object)explorationNodeData, ExplorationNodeData.class);
        ImmutableList result = g.apply((RuleApp)app);
        result.forEach(goal -> {
            goal.node().register((Object)new ExplorationNodeData(), ExplorationNodeData.class);
            String s = goal.node().getNodeInfo().getBranchLabel();
            goal.node().getNodeInfo().setBranchLabel("ExplorationNode: " + s);
        });
        assert (result.size() == 2);
        String labelPostfix = antecedent ? "FALSE" : "TRUE";
        Goal first = (Goal)result.head();
        if (first.node().getNodeInfo().getBranchLabel().endsWith(labelPostfix)) {
            first.setEnabled(false);
            toBeSelected = ((Goal)result.tail().head()).node();
        } else {
            ((Goal)result.tail().head()).setEnabled(false);
            toBeSelected = ((Goal)result.head()).node();
        }
        return toBeSelected;
    }

    public Node applyChangeFormula(@Nonnull Goal g, @Nonnull PosInOccurrence pio, @Nonnull Term term, @Nonnull Term newTerm) {
        TacletApp app = this.soundChange(pio, term, newTerm);
        ExplorationNodeData data = ExplorationNodeData.get(g.node());
        data.setExplorationAction(String.format("Edit %s to %s", LogicPrinter.quickPrintTerm((Term)term, (Services)this.services), LogicPrinter.quickPrintTerm((Term)newTerm, (Services)this.services)));
        ImmutableList result = g.apply((RuleApp)app);
        result.forEach(goal -> {
            ExplorationNodeData.get(goal.node());
            String s = goal.node().getNodeInfo().getBranchLabel();
            goal.node().getNodeInfo().setBranchLabel("ExplorationNode: " + s);
        });
        FindTaclet tap = this.getHideTaclet(pio.isInAntec());
        PosTacletApp weakening = PosTacletApp.createPosTacletApp((FindTaclet)tap, (MatchConditions)tap.getMatcher().matchFind(pio.subTerm(), MatchConditions.EMPTY_MATCHCONDITIONS, null), (PosInOccurrence)pio, (Services)this.services);
        String posToWeakening = pio.isInAntec() ? "TRUE" : "FALSE";
        Node toBeSelected = null;
        for (Goal goal2 : result) {
            if (goal2.node().getNodeInfo().getBranchLabel().contains(posToWeakening)) {
                goal2.apply((RuleApp)weakening);
                goal2.node().parent().register((Object)new ExplorationNodeData(), ExplorationNodeData.class);
                toBeSelected = goal2.node();
                continue;
            }
            goal2.setEnabled(false);
        }
        return toBeSelected;
    }

    private TacletApp soundChange(@Nonnull PosInOccurrence pio, @Nonnull Term term, @Nonnull Term newTerm) {
        Taclet cut = this.getCutTaclet();
        Semisequent semisequent = new Semisequent(new SequentFormula(newTerm));
        NoPosTacletApp app = NoPosTacletApp.createNoPosTacletApp((Taclet)cut);
        SchemaVariable sv = (SchemaVariable)app.uninstantiatedVars().iterator().next();
        app = app.addCheckedInstantiation(sv, semisequent.getFirst().formula(), this.services, true);
        return app;
    }

    public void soundHide(Goal g, PosInOccurrence pio, Term term) {
        TacletApp app = this.createHideTerm(pio);
        ExplorationNodeData explorationNodeData = ExplorationNodeData.get(g.node());
        explorationNodeData.setExplorationAction("Hide " + term);
        ImmutableList result = g.apply((RuleApp)app);
        result.forEach(goal -> ExplorationNodeData.get(goal.node()));
    }

    private TacletApp createHideTerm(PosInOccurrence pio) {
        FindTaclet tap = this.getHideTaclet(pio.isInAntec());
        MatchConditions match = tap.getMatcher().matchFind(pio.subTerm(), MatchConditions.EMPTY_MATCHCONDITIONS, this.services);
        return PosTacletApp.createPosTacletApp((FindTaclet)tap, (MatchConditions)match, (PosInOccurrence)pio, (Services)this.services);
    }
}

