/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.exploration.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.proof.Goal;
import java.awt.event.ActionEvent;
import org.key_project.exploration.ProofExplorationService;
import org.key_project.exploration.actions.ExplorationAction;

public class DeleteFormulaAction
extends ExplorationAction {
    private final PosInSequent posInSeq;

    public DeleteFormulaAction(PosInSequent pis) {
        this(pis, MainWindow.getInstance());
    }

    public DeleteFormulaAction(PosInSequent pis, MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Delete formula");
        this.posInSeq = pis;
        if (pis.getPosInOccurrence() != null) {
            this.setEnabled(!pis.isSequent() & pis.getPosInOccurrence().isTopLevel());
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.posInSeq.isSequent() || this.posInSeq.getPosInOccurrence() != null && !this.posInSeq.getPosInOccurrence().isTopLevel()) {
            return;
        }
        PosInOccurrence pio = this.posInSeq.getPosInOccurrence();
        if (pio == null) {
            return;
        }
        Term term = pio.subTerm();
        Goal g = this.getMediator().getSelectedGoal();
        ProofExplorationService service = ProofExplorationService.get(this.getMediator());
        service.soundHide(g, pio, term);
    }
}

