/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.exploration.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import java.awt.event.ActionEvent;
import org.key_project.exploration.ProofExplorationService;
import org.key_project.exploration.actions.ExplorationAction;

public class EditFormulaAction
extends ExplorationAction {
    private final transient PosInSequent posInSeq;

    public EditFormulaAction(PosInSequent pis) {
        this(pis, MainWindow.getInstance());
    }

    public EditFormulaAction(PosInSequent pis, MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Edit formula");
        this.posInSeq = pis;
        this.setEnabled(!pis.isSequent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.posInSeq.isSequent()) {
            return;
        }
        TermBuilder tb = this.getMediator().getServices().getTermBuilder();
        PosInOccurrence pio = this.posInSeq.getPosInOccurrence();
        Term term = pio.subTerm();
        SequentFormula sf = pio.sequentFormula();
        Goal g = this.getMediator().getSelectedGoal();
        Term newTerm = this.promptForTerm(this.mainWindow, term);
        if (newTerm.equals(term)) {
            return;
        }
        ProofExplorationService api = ProofExplorationService.get(this.getMediator());
        Node toBeSelected = api.applyChangeFormula(g, pio, sf.formula(), tb.replace(sf.formula(), pio.posInTerm(), newTerm));
        this.getMediator().getSelectionModel().setSelectedNode(toBeSelected);
    }
}

