/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.exploration.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.nparser.KeyIO;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.util.parsing.BuildingException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.JOptionPane;
import org.key_project.exploration.ExplorationModeModel;

public abstract class ExplorationAction
extends MainWindowAction {
    private static final long serialVersionUID = -1662459714803539089L;

    public ExplorationAction(MainWindow mw) {
        super(mw);
    }

    public void actionPerformed(ActionEvent e) {
    }

    Term promptForTerm(MainWindow window, Term term) {
        String initialValue = term == null ? "" : LogicPrinter.quickPrintTerm((Term)term, (Services)this.getMediator().getServices());
        Term result = null;
        while (result == null) {
            String input = JOptionPane.showInputDialog((Component)window, "Input a formula:", initialValue);
            if (input == null) {
                return null;
            }
            KeyIO io = new KeyIO(window.getMediator().getServices());
            try {
                result = io.parseExpression(input);
                if (term == null || result.sort().equals(term.sort())) continue;
                JOptionPane.showMessageDialog((Component)window, String.format("%s is of sort %s, but we need a term of sort %s", result, result.sort(), term.sort()), "Sort mismatch", 0);
                result = null;
            }
            catch (BuildingException e) {
                JOptionPane.showMessageDialog((Component)window, e.getMessage(), "Malformed input", 0);
            }
        }
        return result;
    }

    public ExplorationModeModel getModel() {
        return Objects.requireNonNull((ExplorationModeModel)this.getMediator().lookup(ExplorationModeModel.class));
    }
}

