/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.exploration.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.key_project.exploration.ExplorationModeModel;
import org.key_project.exploration.Icons;

public class ShowInteractiveBranchesAction
extends KeyAction {
    private final transient ExplorationModeModel model;

    public ShowInteractiveBranchesAction(ExplorationModeModel model, MainWindow mainWindow) {
        this.model = model;
        this.setName("Hide justification");
        this.setTooltip("Exploration actions are \noften done using a cut. Choose to hide\n the second cut-branches from the view \nto focus on the actions. Uncheck to focus on these branches.");
        this.setMenuPath("View.Exploration");
        this.putValue("CHECKBOX", true);
        model.addPropertyChangeListener("exploreModeSelected", e -> this.updateEnable());
        ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().addSettingsListener(e -> this.updateEnable());
        this.updateEnable();
    }

    private void updateEnable() {
        this.setSelected(!this.model.isShowInteractiveBranches());
        this.setEnabled(this.model.isExplorationModeSelected());
        Icon secondBranch = this.model.isShowInteractiveBranches() ? Icons.SECOND_BRANCH_HIDE.get(16.0f) : Icons.SECOND_BRANCH;
        this.setIcon(secondBranch);
    }

    public void actionPerformed(ActionEvent e) {
        if (MainWindow.getInstance().getProofTreeView().getDelegateModel() == null) {
            return;
        }
        boolean showInteractiveBranches = this.model.isShowInteractiveBranches();
        this.model.setShowInteractiveBranches(!showInteractiveBranches);
        if (this.model.isShowInteractiveBranches()) {
            this.model.setExplorationTacletAppState(ExplorationModeModel.ExplorationState.WHOLE_APP);
        } else {
            this.model.setExplorationTacletAppState(ExplorationModeModel.ExplorationState.SIMPLIFIED_APP);
        }
    }
}

