/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.exploration.actions;

import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import java.awt.event.ActionEvent;
import org.key_project.exploration.ExplorationModeModel;
import org.key_project.exploration.Icons;

public class ToggleExplorationAction
extends KeyAction {
    public static final String MENU_PATH = "View.Exploration";
    private final transient ExplorationModeModel model;

    public ToggleExplorationAction(ExplorationModeModel model, final MainWindow mainWindow) {
        this.model = model;
        this.setName("Exploration Mode");
        this.setTooltip("Choose to start ExplorationMode");
        this.setIcon(Icons.EXPLORE.get());
        this.setSelected(model.isExplorationModeSelected());
        this.setMenuPath(MENU_PATH);
        this.putValue("CHECKBOX", true);
        model.addPropertyChangeListener("exploreModeSelected", e -> this.setSelected(model.isExplorationModeSelected()));
        mainWindow.getMediator().getSelectionModel().addKeYSelectionListener(new KeYSelectionListener(){

            public void selectedProofChanged(KeYSelectionEvent e) {
                ToggleExplorationAction.this.updateEnable(mainWindow);
            }

            public void selectedNodeChanged(KeYSelectionEvent e) {
            }
        });
        this.updateEnable(mainWindow);
    }

    private void updateEnable(MainWindow mainWindow) {
        this.setEnabled(mainWindow.getProofTreeView().getDelegateModel() != null);
    }

    public void actionPerformed(ActionEvent e) {
        this.model.setExplorationModeSelected(!this.model.isExplorationModeSelected());
    }
}

