/*
 * Decompiled with CFR 0.152.
 */
package org.key_project.exploration.ui;

import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.help.HelpFacade;
import de.uka.ilkd.key.gui.help.HelpInfo;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.RuleAppListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.key_project.exploration.ExplorationNodeData;
import org.key_project.exploration.Icons;

@HelpInfo(path="/Using Key/Exploration/")
public class ExplorationStepsList
extends JPanel
implements TabPanel {
    private final JLabel hasExplorationSteps = new JLabel();
    private final PruneExplorationAction actionPruneExploration = new PruneExplorationAction();
    private final JumpToNodeAction actionJumpToNode = new JumpToNodeAction();
    private final DefaultListModel<Node> listModelExploration = new DefaultListModel();
    private final JList<Node> listExplorations = new JList<Node>(this.listModelExploration);
    private final DefaultTreeModel treeModelExploration = new DefaultTreeModel(null);
    private final JTree treeExploration = new JTree(this.treeModelExploration);
    private final transient KeYMediator mediator;
    private final transient RuleAppListener ruleAppListener = e1 -> {
        this.createModel(e1.getSource());
        TreePath selectionPath = this.treeExploration.getSelectionModel().getSelectionPath();
        this.setTreeExpandedState(this.treeExploration, true);
        this.treeExploration.setSelectionPath(selectionPath);
    };
    private transient Proof currentProof;
    private boolean enabled;

    public ExplorationStepsList(MainWindow window) throws HeadlessException {
        this.mediator = window.getMediator();
        this.initialize();
    }

    public void setProof(@Nullable Proof proof) {
        if (this.currentProof != null) {
            this.currentProof.removeRuleAppListener(this.ruleAppListener);
        }
        if (proof != null) {
            proof.addRuleAppListener(this.ruleAppListener);
        }
        this.currentProof = proof;
        this.createModel(proof);
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean old = this.enabled;
        this.enabled = enabled;
        if (old != enabled) {
            this.createModel(this.currentProof);
        }
    }

    public Proof getProof() {
        return this.currentProof;
    }

    private void createModel(@Nullable Proof model) {
        this.listModelExploration.clear();
        if (this.enabled && model != null && !model.isDisposed()) {
            Node root = model.root();
            MyTreeNode rootNode = new MyTreeNode(root);
            this.treeModelExploration.setRoot(rootNode);
            List<Node> explorationNodes = this.collectAllExplorationSteps(root, this.treeModelExploration, rootNode);
            explorationNodes.forEach(this.listModelExploration::addElement);
        }
        this.updateLabel();
    }

    private void updateLabel() {
        this.hasExplorationSteps.setIcon(Icons.EXPLORE.get());
        this.hasExplorationSteps.setToolTipText("The current proof contains exploratory proof steps.");
        if (this.listModelExploration.isEmpty()) {
            this.hasExplorationSteps.setIcon(Icons.EXPLORE_DISABLE.get());
            this.hasExplorationSteps.setToolTipText("The current proof does not contain any exploratory proof steps.");
        }
    }

    private List<Node> collectAllExplorationSteps(Node root, DefaultTreeModel dtm, MyTreeNode rootNode) {
        ArrayList<Node> list = new ArrayList<Node>();
        this.findExplorationChildren(root, list, dtm, rootNode);
        return list;
    }

    @Nonnull
    public Collection<CAction> getTitleCActions() {
        CButton helpButton = new CButton(null, IconFactory.HELP.get());
        helpButton.addActionListener(e -> HelpFacade.openHelp((String)"/Using%20KeY/Exploration/"));
        return Collections.singleton(helpButton);
    }

    private void findExplorationChildren(@Nonnull Node node, @Nonnull ArrayList<Node> foundNodes, @Nonnull DefaultTreeModel dtm, @Nonnull MyTreeNode parent) {
        HashSet<Node> reached = new HashSet<Node>(512000);
        ArrayDeque<Node> nodes = new ArrayDeque<Node>(8);
        nodes.add(node);
        while (!nodes.isEmpty()) {
            Node n = (Node)nodes.pollLast();
            ExplorationNodeData explorationNodeData = (ExplorationNodeData)n.lookup(ExplorationNodeData.class);
            if (explorationNodeData != null && explorationNodeData.getExplorationAction() != null) {
                MyTreeNode newNode = new MyTreeNode(n);
                dtm.insertNodeInto(newNode, parent, 0);
                parent = newNode;
                foundNodes.add(n);
            }
            reached.add(n);
            for (Node child : n) {
                if (reached.contains(child)) continue;
                nodes.push(child);
            }
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.listExplorations.setCellRenderer(new MyCellRenderer());
        this.listExplorations.addListSelectionListener(e -> {
            Node selected;
            if (!e.getValueIsAdjusting() && (selected = this.listExplorations.getSelectedValue()) != null) {
                TreePath treePath = this.getTreePath(selected);
                if (treePath != null) {
                    this.treeExploration.setSelectionPath(treePath);
                }
                this.mediator.getSelectionModel().setSelectedNode(selected);
            }
        });
        this.listExplorations.getSelectionModel().addListSelectionListener(e -> {
            this.actionJumpToNode.setEnable();
            this.actionPruneExploration.setEnable();
        });
        this.actionJumpToNode.setEnable();
        this.actionPruneExploration.setEnable();
        this.treeExploration.addTreeSelectionListener(e -> {
            MyTreeNode selectedNode = (MyTreeNode)this.treeExploration.getLastSelectedPathComponent();
            if (selectedNode != null) {
                this.mediator.getSelectionModel().setSelectedNode(selectedNode.getData());
                int selectionIndex = this.getSelectionIndex(selectedNode.getData());
                if (selectionIndex > -1) {
                    this.listExplorations.setSelectedIndex(selectionIndex);
                }
            }
        });
        this.treeExploration.setShowsRootHandles(true);
        this.setTreeExpandedState(this.treeExploration, true);
        this.treeExploration.setCellRenderer(new MyTreeCellRenderer());
        JScrollPane p2 = new JScrollPane(this.listExplorations);
        p2.setBorder(BorderFactory.createTitledBorder("List of Exploration"));
        JScrollPane p1 = new JScrollPane(this.treeExploration);
        p1.setBorder(BorderFactory.createTitledBorder("Explorations in Proof"));
        JSplitPane root = new JSplitPane(0, p2, p1);
        this.add((Component)root, "Center");
        this.add((Component)this.createBottomPanel(), "South");
    }

    private JPanel createBottomPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 2, 2));
        buttonPanel.add(new JButton((Action)((Object)this.actionJumpToNode)));
        buttonPanel.add(new JButton((Action)((Object)this.actionPruneExploration)));
        return buttonPanel;
    }

    @Nonnull
    public String getTitle() {
        return "Exploration Steps";
    }

    @Nonnull
    public JComponent getComponent() {
        return this;
    }

    private void setTreeExpandedState(JTree tree, boolean expanded) {
        MyTreeNode node = (MyTreeNode)tree.getModel().getRoot();
        if (node != null) {
            this.setNodeExpanded(tree, node, expanded);
        }
    }

    private void setNodeExpanded(JTree tree, MyTreeNode node, boolean expanded) {
        ArrayList<MyTreeNode> list = new ArrayList<MyTreeNode>();
        if (node.children() != null) {
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                list.add((MyTreeNode)children.nextElement());
            }
            list.forEach(myTreeNode -> this.setNodeExpanded(tree, (MyTreeNode)myTreeNode, expanded));
            if (!expanded && node.isRoot()) {
                return;
            }
            TreePath path = new TreePath(node.getPath());
            if (expanded) {
                tree.expandPath(path);
            } else {
                tree.collapsePath(path);
            }
        }
    }

    private TreePath getTreePath(Node n) {
        MyTreeNode rootNode = (MyTreeNode)this.treeModelExploration.getRoot();
        Enumeration<TreeNode> treeNodeEnumeration = rootNode.depthFirstEnumeration();
        while (treeNodeEnumeration.hasMoreElements()) {
            TreeNode treeNode = treeNodeEnumeration.nextElement();
            if (!((MyTreeNode)treeNode).getData().equals(n)) continue;
            return new TreePath(treeNode);
        }
        return null;
    }

    private int getSelectionIndex(Node n) {
        for (int i = 0; i < this.listModelExploration.size(); ++i) {
            if (!this.listModelExploration.getElementAt(i).equals(n)) continue;
            return i;
        }
        return -1;
    }

    public JLabel getHasExplorationSteps() {
        return this.hasExplorationSteps;
    }

    private class JumpToNodeAction
    extends KeyAction {
        public JumpToNodeAction() {
            this.setName("Jump To Node");
        }

        public void setEnable() {
            this.setEnabled(!ExplorationStepsList.this.listExplorations.isSelectionEmpty());
        }

        public void actionPerformed(ActionEvent e) {
            Node selectedValue = ExplorationStepsList.this.listExplorations.getSelectedValue();
            if (selectedValue != null) {
                ExplorationStepsList.this.mediator.getSelectionModel().setSelectedNode(selectedValue);
            }
        }
    }

    private class PruneExplorationAction
    extends KeyAction {
        public PruneExplorationAction() {
            this.setName("Prune selected exploration");
        }

        public void setEnable() {
            this.setEnabled(!ExplorationStepsList.this.listExplorations.isSelectionEmpty());
        }

        public void actionPerformed(ActionEvent e) {
            Node selectedValue = ExplorationStepsList.this.listExplorations.getSelectedValue();
            Object lastSelectedPathComponent = ExplorationStepsList.this.treeExploration.getLastSelectedPathComponent();
            Node explorationNode = null;
            if (lastSelectedPathComponent != null) {
                MyTreeNode selectedNode = (MyTreeNode)lastSelectedPathComponent;
                ExplorationStepsList.this.mediator.getUI().getProofControl().pruneTo(selectedNode.getData());
                explorationNode = selectedNode.getData();
            }
            if (selectedValue != null) {
                ExplorationStepsList.this.mediator.getUI().getProofControl().pruneTo(selectedValue);
                if (explorationNode == null) {
                    explorationNode = selectedValue;
                }
            }
            if (explorationNode != null) {
                ExplorationNodeData lookup = (ExplorationNodeData)explorationNode.lookup(ExplorationNodeData.class);
                explorationNode.deregister((Object)lookup, ExplorationNodeData.class);
            }
            ExplorationStepsList.this.createModel(ExplorationStepsList.this.mediator.getSelectedProof());
        }
    }

    private static class MyTreeNode
    extends DefaultMutableTreeNode {
        private transient Node data;

        MyTreeNode(Node data) {
            super(data);
            this.data = data;
        }

        public Node getData() {
            return this.data;
        }

        public void setData(Node data) {
            this.data = data;
        }

        @Override
        public String toString() {
            return Integer.toString(this.data.serialNr());
        }
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel lbl = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            MyTreeNode n = (MyTreeNode)value;
            ExplorationNodeData expData = (ExplorationNodeData)n.getData().lookup(ExplorationNodeData.class);
            if (n.isRoot()) {
                if (expData != null && expData.getExplorationAction() != null) {
                    lbl.setText("Root Node" + n.getData().serialNr() + " " + expData.getExplorationAction());
                } else {
                    lbl.setText("Root Node");
                }
            } else if (expData != null && expData.getExplorationAction() != null) {
                lbl.setText(n.getData().serialNr() + " " + expData.getExplorationAction());
            }
            return lbl;
        }
    }

    private static class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel lbl = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Node n = (Node)value;
            ExplorationNodeData expData = (ExplorationNodeData)n.lookup(ExplorationNodeData.class);
            if (expData != null && expData.getExplorationAction() != null) {
                lbl.setText(n.serialNr() + " " + expData.getExplorationAction());
            }
            return lbl;
        }
    }
}

